// CLS_DlgDEVSTUS.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "CLS_DlgProofDeviceStatus.h"


// CLS_DlgDEVSTUS Ի

IMPLEMENT_DYNAMIC(CLS_DlgDEVSTUS, CDialog)

CLS_DlgDEVSTUS::CLS_DlgDEVSTUS(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CLS_DlgDEVSTUS::IDD, pParent)
{

}

CLS_DlgDEVSTUS::~CLS_DlgDEVSTUS()
{
}

void CLS_DlgDEVSTUS::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CBO_CHANNEL_NO, m_cboChannelNo);
	DDX_Control(pDX, IDC_STC_ONLINE_OR_NOT, m_stcOnlineOrNot);
	DDX_Control(pDX, IDC_CBO_HAND_AUTO, m_cboHandAuto);
	DDX_Control(pDX, IDC_CBO_CODE_MODE, m_cboCodeType);
	DDX_Control(pDX, IDC_CBO_SET_TYPE, m_cboSetType);
	DDX_Control(pDX, IDC_EDIT_ENCODE_WIDTH, m_edtEncodeWidth);
	DDX_Control(pDX, IDC_EDIT_ENCODE_HEIGHT, m_edtEncodeHeight);
	DDX_Control(pDX, IDC_EDIT_ENCODE_FRAMERATE, m_edtEncodeFrameRate);
	DDX_Control(pDX, IDC_EDIT_ENCODE_BITRATE, m_edtEncodeBitRate);
	DDX_Control(pDX, IDC_CBO_CHANNEL_TYPE, m_cboChannelType);
}


BEGIN_MESSAGE_MAP(CLS_DlgDEVSTUS, CDialog)
	ON_CBN_SELCHANGE(IDC_CBO_CHANNEL_NO, &CLS_DlgDEVSTUS::OnCbnSelchangeCboChannelNo)
	ON_BN_CLICKED(IDC_BTN_SET_PROOFADJUST, &CLS_DlgDEVSTUS::OnBnClickedBtnSetProofadjust)
	ON_BN_CLICKED(IDC_BUTTON_ENCODE_PARA, &CLS_DlgDEVSTUS::OnBnClickedButtonEncodePara)
	ON_CBN_SELCHANGE(IDC_CBO_CHANNEL_TYPE, &CLS_DlgDEVSTUS::OnCbnSelchangeCboChannelType)
END_MESSAGE_MAP()


// CLS_DlgDEVSTUS Ϣ

void CLS_DlgDEVSTUS::OnCbnSelchangeCboChannelNo()
{
	UpdateOnLineStatus(m_iLogonId);
}

void CLS_DlgDEVSTUS::Initialize()
{
	//CreateChannelCombo(m_iLogonId, &m_cboChannelNo);
    m_cboChannelType.SetCurSel(0);
	UpdateChannel();
	m_cboHandAuto.ResetContent();
	m_cboHandAuto.AddString(GetText(IDS_SETING_MANUAL));
	m_cboHandAuto.AddString(GetText(IDS_SETTING_AUTO));
	m_cboHandAuto.SetCurSel(0);

	m_cboCodeType.ResetContent();
	m_cboCodeType.AddString("HDMI");
	m_cboCodeType.AddString("VGA");
	m_cboCodeType.SetCurSel(0);

	m_cboSetType.ResetContent();
	m_cboSetType.AddString(GetText(IDS_STRING_VIDEO_STYLE));
	m_cboSetType.AddString(GetText(IDS_STRING_VIDEO_COLOR));
	m_cboSetType.SetCurSel(0);

	UpdateOnLineStatus(m_iLogonId);

	m_edtEncodeWidth.SetLimitText(DEC_LEN_16);
	m_edtEncodeHeight.SetLimitText(DEC_LEN_16);
	m_edtEncodeFrameRate.SetLimitText(DEC_LEN_16);
	m_edtEncodeBitRate.SetLimitText(DEC_LEN_16);
	UpdateEncodePara();
}

void CLS_DlgDEVSTUS::OnBnClickedBtnSetProofadjust()
{
	int iChannelNo = -1;
	iChannelNo = m_cboChannelNo.GetCurSel();
	ProofAdjust tPrAd = {0};
	tPrAd.iSize = sizeof(ProofAdjust);
	tPrAd.iOperateMethod = m_cboHandAuto.GetCurSel() + 1;
	tPrAd.iVoId = m_cboCodeType.GetCurSel() + 1;
	tPrAd.iType = m_cboSetType.GetCurSel() + 1;
	tPrAd.iChannelType = m_cboChannelType.GetCurSel();
	int iRet = DEC_ClientSendCommand(m_iLogonId, iChannelNo, 0, DEC_COMMAND_PROOF_ADJUST, &tPrAd, sizeof(ProofAdjust));
	if (iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgDEVSTUS::OnBnClickedBtnSetProofadjust] DEC_ClientSendCommand failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_iLogonId);
		return;
	}
}

void CLS_DlgDEVSTUS::UpdateOnLineStatus(int iLogonId)
{
	int iChannelNo = -1;
	iChannelNo =m_cboChannelNo.GetCurSel();
	LocalChannelState tChnsta = {0};
	tChnsta.iBufSize = sizeof(LocalChannelState);
	tChnsta.iChannelNo = iChannelNo;
	tChnsta.iType = 1;//ͨ
	int iRet = DEC_ClientGetDevConfig(iLogonId, iChannelNo, 0, CMD_DEC_CFG_CHANN_STATE, &tChnsta, sizeof(LocalChannelState));
	if (iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgDEVSTUS::OnCbnSelchangeCboChannelNo] DEC_ClientGetDevConfig failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), iLogonId);
		return;
	}
	SetDlgItemInt(IDC_STC_ONLINE_OR_NOT,tChnsta.iState);
}

void CLS_DlgDEVSTUS::OnBnClickedButtonEncodePara()
{
	int iChannelNo = -1;
	iChannelNo = m_cboChannelNo.GetCurSel();
	DecEncodePara tEncodePara = {0};
	tEncodePara.iSize = sizeof(DecEncodePara);
	tEncodePara.iWidth = GetDlgItemInt(IDC_EDIT_ENCODE_WIDTH);
	tEncodePara.iHeight = GetDlgItemInt(IDC_EDIT_ENCODE_HEIGHT);
	tEncodePara.iFrameRate = GetDlgItemInt(IDC_EDIT_ENCODE_FRAMERATE);
	tEncodePara.iBitRate = GetDlgItemInt(IDC_EDIT_ENCODE_BITRATE);
	int iRet = DEC_ClientSetDevConfig(m_iLogonId, iChannelNo, 0, CMD_DEC_CFG_ENCODERPAPA, &tEncodePara, sizeof(DecEncodePara));
	if (0 != iRet)
	{
		AddLog(LOG_LEVEL_WARN,"[DEC_ClientSetDevConfig:CMD_DEC_CFG_ENCODERPAPA] DEC_ClientSetDevConfig failed!Ret(%d),ID(%d)", iRet, m_iLogonId);
	}
}


void CLS_DlgDEVSTUS::UpdateEncodePara()
{
	int iChannelNo = -1;
	iChannelNo = m_cboChannelNo.GetCurSel();
	DecEncodePara tEncodePara = {0};
	tEncodePara.iSize = sizeof(DecEncodePara);
	int iRet = DEC_ClientGetDevConfig(m_iLogonId, iChannelNo, 0, CMD_DEC_CFG_ENCODERPAPA, &tEncodePara, sizeof(DecEncodePara));
	if (0 == iRet)
	{
		SetDlgItemInt(IDC_EDIT_ENCODE_WIDTH, tEncodePara.iWidth);
		SetDlgItemInt(IDC_EDIT_ENCODE_HEIGHT, tEncodePara.iHeight);
		SetDlgItemInt(IDC_EDIT_ENCODE_FRAMERATE, tEncodePara.iFrameRate);
		SetDlgItemInt(IDC_EDIT_ENCODE_BITRATE, tEncodePara.iBitRate);
	}
	else
	{
		AddLog(LOG_LEVEL_WARN,"[DEC_ClientGetDevConfig:CMD_DEC_CFG_ENCODERPAPA] DEC_ClientSetDevConfig failed!Ret(%d),ID(%d)", iRet, m_iLogonId);
	}
}

void CLS_DlgDEVSTUS::UpdateChannel()
{
	int iChannelType = m_cboChannelType.GetCurSel();

	tDevInfo tDevInformation = {0};
	int iRet = DEC_ClientGetDevConfig(m_iLogonId, 0, 0, CMD_DEC_CFG_DEV_INFO, &tDevInformation, sizeof(tDevInfo));
	if (iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgDEVSTUS::OnCbnSelchangeCboChannelNo] DEC_ClientGetDevConfig failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_iLogonId);
		return;
	}
	CString csTemp = "";

	int iChannelNum = 0;

	if(PROOFADJUST_CHANNELTYPE_LOCALINPUT==iChannelType)
	{
		iChannelNum = tDevInformation.iLocalInChnNum;
	}else{
		iChannelNum = tDevInformation.iEncChanNum;
	}

	m_cboChannelNo.ResetContent();
	for(int i = 0; i < iChannelNum; i++)
	{
		csTemp.Format(_T("%s%d"),GetText(IDS_MAIN_CHANNEL),i);
		m_cboChannelNo.AddString(csTemp);
	}
	m_cboChannelNo.SetCurSel(0);
}
void CLS_DlgDEVSTUS::OnCbnSelchangeCboChannelType()
{
	// TODO: Add your control notification handler code here
	UpdateChannel();
}
